<?php
/* --------------------------------------------------------------
 HttpKernel.php 2020-03-20
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\Kernel;

use Gambio\Core\Application\Application;
use Slim\App as SlimApp;

/**
 * Class HttpKernel
 * @package Gambio\Core\Application\Kernel
 */
class HttpKernel implements Kernel
{
    /**
     * @var Application
     */
    private $application;
    
    
    /**
     * @inheritDoc
     */
    public function bootstrap(Application $application, Bootstrapper $bootstrapper): void
    {
        $this->application = $application;
        $bootstrapper->boot($this->application);
    }
    
    
    /**
     * @inheritDoc
     */
    public function run(): void
    {
        /** @var SlimApp $slim */
        $slim = $this->application->get(SlimApp::class);
        $slim->setBasePath(rtrim(dirname($_SERVER['SCRIPT_NAME']), '/'));
        $slim->run();
    }
}